import { json } from '@sveltejs/kit';
import { db } from '$lib/server/db.js';

/** @type {import('./$types').RequestHandler} */
export async function GET({ params }) {
  try {
    const id = parseInt(params.id);
    const [attendance] = await db.query('SELECT * FROM attendance WHERE id = ?', [id]);
    
    if (attendance.length === 0) {
      return json({ error: 'Data kehadiran tidak ditemukan' }, { status: 404 });
    }
    
    return json({ success: true, data: attendance[0] });
  } catch (error) {
    console.error('Get attendance error:', error);
    return json({ error: 'Gagal mengambil data kehadiran' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function PUT({ params, request }) {
  try {
    const id = parseInt(params.id);
    const data = await request.json();
    const { studentId, studentName, class: className, date, status, subject, teacher } = data;

    if (!studentId || !date || !status) {
      return json({ error: 'ID Siswa, Tanggal, dan Status wajib diisi' }, { status: 400 });
    }

    await db.query(
      `UPDATE attendance 
       SET studentId = ?, studentName = ?, class = ?, date = ?, status = ?, subject = ?, teacher = ?
       WHERE id = ?`,
      [
        studentId,
        studentName || null,
        className || null,
        date,
        status.trim(),
        subject || null,
        teacher || null,
        id
      ]
    );

    return json({ success: true, message: 'Data kehadiran berhasil diupdate' });
  } catch (error) {
    console.error('Update attendance error:', error);
    return json({ error: 'Gagal mengupdate data kehadiran' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function DELETE({ params }) {
  try {
    const id = parseInt(params.id);
    await db.query('DELETE FROM attendance WHERE id = ?', [id]);
    return json({ success: true, message: 'Data kehadiran berhasil dihapus' });
  } catch (error) {
    console.error('Delete attendance error:', error);
    return json({ error: 'Gagal menghapus data kehadiran' }, { status: 500 });
  }
}
